function [sample_num, feature_num, X, Y] = read_data(train_filename)
% READ_DATA Load training data from an Excel file.
%
% Inputs:
%   train_filename - Name of the Excel file containing training data.
%
% Outputs:
%   sample_num   - Number of training samples.
%   feature_num  - Number of features per sample.
%   X            - Feature matrix.
%   Y            - Label vector.

    % Read training data from Excel file
    data = xlsread(train_filename);

    % Extract labels (last column)
    Y = data(:, end);

    % Extract features (all columns except the last)
    X = data(:, 1:end-1);

    % Optional: Convert label 0 to num_labels (e.g., 3)
    % num_labels = 3;
    % Y(Y == 0) = num_labels;

    % Get size information of the feature matrix
    [sample_num, feature_num] = size(X);

    % Display number of features
    disp('feature_num: ')
    fprintf(' %d \n', feature_num);

    % Display number of samples
    disp('sample_num: ')
    fprintf(' %d \n', sample_num);

    % Display label distribution
    disp('table for data: ')
    tabulate(Y)
end
